/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-10-04
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ACTIVECONVFKRAYLEIGH_H
#define ACTIVECONVFKRAYLEIGH_H

#include "ActiveConvFKVertical.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT ActiveConvFKRayleigh : public ActiveConvFKVertical
  {
  public:
    ActiveConvFKRayleigh(FKCache * gridCache)
    : ActiveConvFKVertical(gridCache) {_RoverN=0.0; _ellipticity=0.0;}

    void setGrid(FKGridSearch * g, double step, double size);
    bool isOnLimit(const Point& k, double frequency) const;

    bool setSource(const QVector<int>& blocks);
    void addCrossSpectrum();

    double value(const Point& kell) const;

    Point2D waveNumber(const Point& k) const {return Point2D(k.x(), 0.0);}
    bool hasEllipticity() const {return true;}
    double ellipticity(const Point& kell);
    double noise(const Point&) const;
  protected:
    double ellipticityHelper(double ellh, double ellz);

    double _RoverN;
    double _ellipticity;
  };

} // namespace ArrayCore

#endif // ACTIVECONVFKRAYLEIGH_H

