/***************************************************************************
**
**  This file is part of waran.
**
**  waran is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  waran is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2013-04-07
**  Copyright: 2013-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef TAPECOORDINATEITEM_H
#define TAPECOORDINATEITEM_H

#include <QGpCoreTools.h>

#include "TapePoint.h"

class TapeCoordinateItem : public QAbstractTableModel
{
  Q_OBJECT
public:
  TapeCoordinateItem(QObject * parent=nullptr);

  int indexOf(const QString& name)const;
  void add(const QString& name);
  const QList<TapePoint>& points() const {return _points;}
  void setPoint(const QString& name, const Point2D& p, const QGpCoreMath::Ellipse& stddev);
  void setPriorCoordinates(int index);

  virtual int rowCount(const QModelIndex& parent) const;
  virtual int	columnCount(const QModelIndex& parent) const;
  virtual QVariant data(const QModelIndex & index, int role) const;
  virtual bool setData(const QModelIndex & index, const QVariant & value, int role=Qt::EditRole);
  virtual QVariant headerData(int section, Qt::Orientation orientation, int role) const;
  Qt::ItemFlags flags(const QModelIndex& index) const;

  bool load(const QString& fileName);
  bool save(const QString& fileName) const;
signals:
  void pointChanged();
  void typeChanged();
private:
  QList<TapePoint> _points;
};

#endif // TAPECOORDINATEITEM_H
