/***************************************************************************
**
**  This file is part of waran.
**
**  waran is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  waran is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2012-02-04
**  Copyright: 2012-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SEISMICPARAMETERS_H
#define SEISMICPARAMETERS_H

#include <GeopsyCore.h>

class SeismicParameters : public AbstractParameters
{
public:
  SeismicParameters();
  SeismicParameters(const SeismicParameters& o);

  virtual AbstractParameters * clone() const {return new SeismicParameters(*this);}

  const int& frequency() const {return _frequency;}
  void setFrequency(const int& f) {_frequency=f;}

  const int& hardwareGain() const {return _hardwareGain;}
  void setHardwareGain(const int& h) {_hardwareGain=h;}
private:
  int _frequency, _hardwareGain;
};

#endif // SEISMICPARAMETERS_H

