/***************************************************************************
**
**  This file is part of waran.
**
**  waran is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  waran is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2013-04-07
**  Copyright: 2013-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef DISTANCE_H
#define DISTANCE_H

#include <QtCore>

class Distance
{
public:
  Distance() {_measured=0.0; _computed=0.0;}
  Distance(const QString& n1, const QString& n2, double v);
  Distance(const Distance& o);
  ~Distance() {}

  const QString& node1() const {return _node1;}
  void setNode1(const QString& n) {_node1=n;}

  const QString& node2() const {return _node2;}
  void setNode2(const QString& n) {_node2=n;}

  double measured() const {return _measured;}
  void setMeasured(double d) {_measured=d;}

  double computed() const {return _computed;}
  void setComputed(double d) {_computed=d;}

  QString toString(int precision=6, char format='g') const;
  bool fromString(const StringSection& str);
private:
  QString _node1, _node2;
  double _measured, _computed;
};

#endif // DISTANCE_H
