/***************************************************************************
**
**  This file is part of waran.
**
**  waran is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  waran is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2012-02-04
**  Copyright: 2012-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ACQUISITIONWIDGET_H
#define ACQUISITIONWIDGET_H

#include "ui_AcquisitionWidget.h"
#include "NetworkParameters.h"

class Station;

class AcquisitionWidget : public QWidget, private Ui::AcquisitionWidget
{
  Q_OBJECT
public:
  AcquisitionWidget(QWidget * parent=nullptr);
  ~AcquisitionWidget();

  const NetworkParameters& networkParameters() {return _networkParameters;}
  void setStations(QList<Station *> * list);
private slots:
  void on_seismicStartButton_clicked();
  void on_seismicStopButton_clicked();
  void on_gpsStartButton_clicked();
  void on_gpsStopButton_clicked();
  void on_gpsNavigationButton_clicked();
  void on_gpsDownloadButton_clicked();
  void on_rebootButton_clicked();
  void on_powerOffButton_clicked();
  void on_clearUsbButton_clicked();
  void on_networkParameters_clicked();
  void on_seismicParameters_clicked();
  void adjustColumnWidth();
signals:
  void networkParametersChanged();
private:
  bool checkSelection(const QString& title);

  QList<Station *> * _stations;
  NetworkParameters _networkParameters;
  EventRestrictor _resizeColumns;
};

#endif // ACQUISITIONWIDGET_H
