/***************************************************************************
**
**  This file is part of max2curve.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-05-29
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MAXENTRYLIST_H
#define MAXENTRYLIST_H

#include <QGpCoreMath.h>

#include "MaxEntry.h"

class MaxEntryList : public QList<MaxEntry *>
{
  TRANSLATIONS("MaxEntryList")
public:
  MaxEntryList() {_type=Undefined;}
  ~MaxEntryList();

  enum Type {Undefined, FK, SPAC, TFA, CURVE};

  Type type() const {return _type;}
  void setType(Type t) {_type=t;}

  bool load(QString fileName);
  bool save(QString fileName);
  void toStream(QTextStream& s);

  RealStatisticalValue meanValue(double x, SamplingOption ySampling) const;
  int count(double x) const;
  int count( ) const {return QList<MaxEntry *>::count();}

  void unselectValue(double x, double minSlowness, double maxSlowness);
  void selectAll(double x);
  void selectAll();

  void rejectValue(double minValue, double maxValue);

  IrregularGrid2D initGrid(int nValues, double minValue, double maxValue, SamplingOption ySampling);
  void fillGrid(IrregularGrid2D& grid);

  void rejectPower(double relativeFactor, double absoluteFactor);
  void unselectPower(double relativeFactor, double absoluteFactor);
  void unselectWavenumber(double minWavenumber, double maxWavenumber);
  void keepRing(int ringIndex);
  void keepComponent(int componentIndex);
  void rejectAmplitudeVerticalFactor(double factor);
  void rejectAmplitudeVerticalAbsolute(double ampZ);
  void rejectAmplitudeHorizontalAbsolute(double ampH);
  void rejectLowerDelays(double minDelay);
  void rejectHigherDelays(double maxDelay);
  void rejectNPeaksPerMinute(double nppm);
  void rejectNPeaksPerFrequency(int npf);
  void rejectDelay(double delay);
  void unselectAmplitude(double factor);
  void rejectTime(double min, double max);
private:
  static bool lessThan(const MaxEntry * e1, const MaxEntry * e2) {return *e1 < *e2;}
  void minPowerVectors(QMap<double,double>& minRelPow, QMap<double,double>& minAbsPow,
                       double relativeFactor, double absoluteFactor);
  void minAmplitudeVectors(QMap<double,double>& minVAmplitude, double factor);
  QList<double> xSamples() const;

  Type _type;
};

#endif // MAXENTRYLIST_H
