/***************************************************************************
**
**  This file is part of matfiles.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-07-20
**  Authors:
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MATFORMAT_H
#define MATFORMAT_H

#include <GeopsyCore.h>

class MatContext;

class MatFormat : public AbstractFileFormat
{
public:
  MatFormat();
  ~MatFormat();

  virtual const QString& xml_tagName() const {return xmlMatFormatTag;}
  static const QString xmlMatFormatTag;

  virtual bool isValid(const QString& fileName) const;
  virtual bool isReadOnly() const {return false;}

  virtual bool load(SignalFile * file) const;
  virtual bool load(const Signal * sig, double * samples) const;
  virtual bool save(const SubSignalPool& subpool, const QString& filePath) const;
private:
#ifndef GP_MATLAB_LIBS
  MatContext * _context;
#endif
};

#endif // MATFORMAT_H
