/***************************************************************************
**
**  This file is part of hvtfa.
**
**  hvtfa is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  hvtfa is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-04-27
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef HVTFAITERATOR_H
#define HVTFAITERATOR_H

#include <GeopsyCore.h>

class HVTFAStationSignals;

class HVTFAIterator
{
public:
  HVTFAIterator(const QList<HVTFAStationSignals *> *  stations,
                const TimeRangeParameters * globalRange);

  bool atEnd() const;
  void next();

  int stationIndex() const {return _currentStation;}
  int rangeIndex() const {return _currentRange;}
  int rangeCount() const {return _rangeList.count();}
  const TimeRange& range() const {return _rangeList.at(_currentRange);}
private:
  void setRangeList();

  const QList<HVTFAStationSignals *> * _stations;
  const TimeRangeParameters * _globalRange;

  int _currentStation;
  int _currentRange;
  QVector<TimeRange> _rangeList;
};

#endif // HVTFAITERATOR_H
