/***************************************************************************
**
**  This file is part of gpspac.
**
**  gpspac is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpspac is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-12-15
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SPACREADER_H
#define SPACREADER_H

#include <QGpCoreTools.h>
#include <QGpCoreWave.h>

class SpacReader : public ArgumentStdinReader
{
  TRANSLATIONS("SpacReader")
public:
  SpacReader();
  ~SpacReader();

  bool setOptions(int& argc, char ** argv);
protected:
  virtual bool parse(QTextStream& s);
private:
  int _nModes;
  bool _oneMode;
  bool _vertical;
  bool _radial;
  bool _transverse;
  double _alpha;
  QVector<AutocorrRing> _rings;
  DispersionFactory * _dispersionFactory;
  AutocorrFactory * _autocorrFactory;
};

#endif // SPACREADER_H
