/***************************************************************************
**
**  This file is part of gplivemodel.
**
**  gplivemodel is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gplivemodel is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-10-15
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui>
#if(QT_VERSION > QT_VERSION_CHECK(5, 0, 0))
#include <QtWidgets>
#endif

#include <QGpCoreWave.h>

class Results;
class ControlPanel;

class MainWindow : public QMainWindow
{
  Q_OBJECT
public:
  MainWindow(QWidget * parent=nullptr);
  ~MainWindow();

  void addBackground(GeophysicalModel * m, QString comments);
  Results * results() const {return _results;}
  void loadPanel(QString fileName);
  int scan(GeophysicalModel * m, QString sliderPattern, int nSteps);
public slots:
  void setBackground();
private slots:
  void setReferenceModel();
  void setForeground(GeophysicalModel * m);
  void setToolsMenuState();
  void helpDocumentation();
  void helpAbout();
  void quit();
protected:
  void closeEvent(QCloseEvent * e);
private:
  void addActions();
  void addToolsActions();
  void addHelpActions();

  GeophysicalModel * _templateModel;
  QMenu * _toolsMenu;
  Results * _results;
  QPlainTextEdit * _backgroundModels;
  QPlainTextEdit * _referenceModel;
  QPlainTextEdit * _foregroundModel;
  ControlPanel * _controlPanel;
};

#endif // MAINWINDOW_H
