/***************************************************************************
**
**  This file is part of gphistogram.
**
**  gphistogram is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gphistogram is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-10-27
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GRIDFILTER_H
#define GRIDFILTER_H

#include <QGpGuiMath.h>

#include "ui_GridFilter.h"

class GridFilter : public Dialog, public Ui::GridFilter
{
  Q_OBJECT
public:
  GridFilter(QWidget *parent=nullptr, Qt::WindowFlags f=Qt::Widget);

  void setCurveList(const QList<CurveProperties *>& list);
public slots:
  void enableWidgets();
private slots:
  void on_curve1Name_activated(int);
  void on_curve2Name_activated(int);
};

#endif // GRIDFILTER_H
