/***************************************************************************
**
**  This file is part of geopsyhv.
**
**  geopsyhv is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsyhv is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-08-24
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <SciFigs.h>

#include "HVRotateStation.h"
#include "HVStationSignals.h"
#if 0

/*!
  \class HVRotateStation HVRotateStation.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

HVRotateStation::HVRotateStation(StationSignals * sig)
   : HVStation(sig)
{
  TRACE;
  qDeleteAll(_results);
  _results.clear();
  _gridLayer=nullptr;
}

void HVRotateStation::setResultGraph(int, AxisWindow * w)
{
  TRACE;
  w->xAxis()->setTitle( "Frequency (Hz)" );
  w->xAxis()->setTitleInversedScale( "Period (s)" );
  w->xAxis()->setScaleType(Scale::Log);
  w->xAxis()->setAutoTicks(false);
  w->xAxis()->setMajorTicks(2);
  w->xAxis()->setMinorTicks(0.5);

  w->yAxis()->setNumberType('f');
  w->yAxis()->setTitle( "Azimuth (degrees)" );

  _gridLayer=new IrregularGrid2DPlot(w);
  _gridLayer->setObjectName( "rotatedhv" );
}

AxisWindow * HVRotateStation::resultGraph(int) const
{
  return _gridLayer->graph();
}

void HVRotateStation::start(HVParameters& param)
{
  TRACE;
  // Init grid
  int nFreq=param.sampling().count();
  double da=Angle::radiansToDegrees(param.rotationStep());
  int nAzimuth=qFloor(180.0/da)+1;
  IrregularGrid2D grid(nFreq, nAzimuth);
  for(int iFreq=0; iFreq<nFreq; iFreq++ ) {
    grid.setX(iFreq, param.sampling().value(iFreq) );
  }
  for(int iAzimuth=0; iAzimuth<nAzimuth; iAzimuth++) {
    grid.setY(iAzimuth, iAzimuth*da);
  }

  // Compute the geometrical average of all windows by stacking grids
  grid.init(0.0);
  int n= windowCount();
  SignalDatabase * db=database();
  GeopsyCoreEngine::instance()->setProgressMaximum(db, n-1);
  for(int i=0; i<n; i++) {
    const TimeRange& r=windowAt(i);
    GeopsyCoreEngine::instance()->setProgressValue(db, i);
    computeHV(r, param, grid);
  }
  grid.multiplyValues(1.0/n);
  grid.pow10();
  _gridLayer->setGrid(grid);
}

void HVRotateStation::computeHV(const TimeRange& tw, HVParameters& param, IrregularGrid2D& grid)
{
  TRACE;
  double * values=grid.valuePointer(0, 0);
  _signals->setProcessed(tw, &param);
  int winNSamp=tw.lengthSamples(_signals->originalSignals()->samplingFrequency());
  int nx=grid.nx();
  int ny=grid.ny();
  DoubleSignal * hvWin;
  for(int iy=0; iy<ny; iy++) {
    hvWin=new DoubleSignal(winNSamp);
    hvWin->hv(static_cast<HVStationSignals *>(_signals)->vertical(),
               static_cast<HVStationSignals *>(_signals)->horizontal(grid.y(iy), &param));
    for(int ix=0; ix<nx; ix++)
      *(values++)+=log10(hvWin->interpoleAt(grid.x(ix)));
    delete hvWin;
  }
}

double HVRotateStation::resultMaxAmplitude() const
{
  TRACE;
  return _gridLayer->grid().maximumValue();
}
#endif
