/***************************************************************************
**
**  This file is part of geopsydamping.
**
**  geopsydamping is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsydamping is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-04-15
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef DampingResults_H
#define DampingResults_H

#include <GeopsyCore.h>
#include <SciFigs.h>

class Parameters;

class DampingResults: public GraphicSheetMenu
{
  Q_OBJECT
public:
  DampingResults(QWidget* parent=0);
  ~DampingResults();

  bool compute(int ig, const Signal *sig, const Parameters& param);
  void createObjects(SubSignalPool * subPool);
  void setWindowTitle(QString title) {GraphicSheetMenu::setWindowTitle(title);}

  QMenu * menuTools;
public slots:
  void save(QString fileName=QString());
protected:
  TextEdit ** _comments;
  LineLayer ** _averageCurveLayers;
  //LineLayer ** _stddevCurveLayers;
  LineLayer ** _fitCurveLayers;
  // Used for curve fitting
  static double misfitFunk(double x[] );
  static Curve<Point2D> _aveCurve;
  static int _nSampFit;
  static double _fitW;
  QString _log;
  struct Result {
    QString name;
    double frequency;
    double damping;
    int nWindows;
  };
  QVector<Result> _results;
};

#endif
