/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-09-20
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SORTKEYS_H
#define SORTKEYS_H

#include <QItemDelegate>
#include <QComboBox>

#include <GeopsyCore.h>
#include <QGpGuiTools.h>
#include "ui_SortKeys.h"

class SortKeysDelegate : public QItemDelegate
{
  Q_OBJECT
public:
  SortKeysDelegate(QObject *parent=0);

  QWidget *createEditor(QWidget *parent, const QStyleOptionViewItem &option,
                         const QModelIndex &index) const;
  void setEditorData(QWidget *editor, const QModelIndex &index) const;
  void setModelData(QWidget *editor, QAbstractItemModel *model,
                     const QModelIndex &index) const;
private:
  QStringList _keyList;
};

class SortKeys : public Dialog, public Ui::SortKeys
{
  Q_OBJECT

public:
  SortKeys(QWidget *parent=nullptr, Qt::WindowFlags f=Qt::Widget);

  void getKeys();
public slots:
  void on_addBut_clicked();
  void on_insertBut_clicked();
  void on_deleteBut_clicked();
  void on_keyList_cellChanged (int row, int column);
private:
  void setIndexState(QTableWidgetItem * item, const MetaDataIndex& index);
};

#endif // QTBDIALOG_SORTKEYS_H
