/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-08-30
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include <GeopsyGui.h>

#include "SeismicEventDelegate.h"

/*!
  \class SeismicEventDelegate SeismicEventDelegate.h
  \brief Brief description of class still missing

  Full description of class still missing
*/


QWidget * SeismicEventDelegate::createEditor(QWidget * parent, const QStyleOptionViewItem & option,
                                             const QModelIndex &index) const
{
  TRACE;
  const SeismicEventItem * item=qobject_cast<const SeismicEventItem *>(index.model());
  ASSERT(item);

  switch(index.column()) {
  case 1: {
      QComboBox * w=new QComboBox(parent);
      w->addItems(UtmZone::names());
      return w;
    }
  case 5: {
      QComboBox * w=new QComboBox(parent);
      w->addItems(SeismicEvent::userTypes());
      return w;
    }
  default:
    return QItemDelegate::createEditor(parent, option, index);
  }
}

void SeismicEventDelegate::setEditorData(QWidget *editor, const QModelIndex &index) const
{
  TRACE;
  const SeismicEventItem * item=qobject_cast<const SeismicEventItem *>(index.model());
  ASSERT(item);

  switch(index.column()) {
  case 1:
  case 5: {
      QComboBox * w=qobject_cast<QComboBox *>(editor);
      ASSERT(w);
      w->setCurrentText(index.model()->data(index).toString());
      break;
    }
  default:
    return QItemDelegate::setEditorData(editor, index);
  }
}

void SeismicEventDelegate::setModelData(QWidget *editor, QAbstractItemModel *model,
                                        const QModelIndex &index) const
{
  TRACE;
  const SeismicEventItem * item=qobject_cast<const SeismicEventItem *>(index.model());
  ASSERT(item);

  QVariant oldValue=model->data(index);
  switch(index.column()) {
  case 1:
  case 5: {
      QComboBox * w=qobject_cast<QComboBox *>(editor);
      ASSERT(w);
      model->setData(index, w->currentText());
      break;
    }
  default:
    QItemDelegate::setModelData(editor, model, index);
    break;
  }
  if(oldValue!=model->data(index)) {
    emit dataChanged();
  }
}
