/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-09-20
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpGuiTools.h>
#include "GeopsyAbout.h"
#include "geopsyVersion.h"
#include "geopsyInstallPath.h"

const char * GeopsyAbout::_noticeContents=
  QT_TRANSLATE_NOOP(
    "GeopsyAbout",
    "<p>Using, Copying and Modifying this program is granted to everyone under the terms "
    "of the GNU Public License version 3. <b>However, we would appreciate that you properly "
    "reference this work, released for free, in all your publications or reports achieved "
    "with this software</b>.</p>"
    "<p>Wathelet, M., Chatelain, J.-L., Cornou, C., Di Giulio, G., Guillier, B., Ohrnberger, M. and Savvaidis, A. (2020). "
    "Geopsy: A User-Friendly Open-Source Tool Set for Ambient Vibration Processing. <i>Seismological Research Letters</i>, "
    "<b>91</b>(3), 1878--1889, doi: <a href=\"https://doi.org/10.1785/0220190360\">10.1785/0220190360</a>.</p>"
    "<p>Copyright 2002-2020 by Marc Wathelet (marc.wathelet@ird.fr)</p>"
    "<p>Design  and C++ implementation of core, main frame and plugins:</p>"
    "<p style=\"margin-left: 40px; font-style:italic\">"
      "Marc Wathelet (ISTerre, Grenoble, France)</p>"
    "<p>Array plugin is based upon original ideas from:</p>"
    "<p style=\"margin-left: 40px; font-style:italic\">"
      "Marc Wathelet (ISTerre, Grenoble, France)<br/>"
      "Matthias Orhnberger (IG, Potsdam, Germany)<br/>"
      "Andreas Köhler (IG, Potsdam, Germany)<br/>"
      "Cecile Cornou (ISTerre, Grenoble, France)</p>"
    "<p>HV plugin is based upon orignal ideas from:</p>"
    "<p style=\"margin-left: 40px; font-style:italic\">"
      "Marc Wathelet (ISTerre, Grenoble, France)<br/>"
      "Pierre-Yves Bard (ISTerre, Grenoble, France)<br/>"
      "Jean-Luc Chatelain (ISTerre, Grenoble, France)<br/>"
      "Bertrand Guillier (ISTerre, Grenoble, France)</p>"
    "<p>Damping plugin is based upon orignal ideas from:</p>"
    "<p style=\"margin-left: 40px; font-style:italic\">"
      "Marc Wathelet (ISTerre, Grenoble, France)<br/>"
      "François Dunand (Geoter, Grenoble, France)</p>"
    "<p>TFA plugin are based upon original ideas from:</p>"
    "<p style=\"margin-left: 40px; font-style:italic\">"
      "Donat Fäh (ETH, Zurich, Switzerland)<br/>"
      "Miriam Kristekova (GI, Bratislava, Slovak Republic)<br/>"
      "Hans-Balder Havenith (ULg, Liège, Belgium)</p>"
    "<p>Some file filters were written by:</p>"
    "<p style=\"margin-left: 40px; font-style:italic\">"
      "Jacques Deparis (LIRIGM, Grenoble, France)</p>"
    "<p>Bug hunting and fruitful suggestions:</p>"
    "<p style=\"margin-left: 40px; font-style:italic\">"
      "Sylvette Bonnefoy (IRSN, Paris, France)<br/>"
      "Heloïse Cadet (LGIT-CETE, Grenoble, France)<br/>"
      "Jean-Luc Chatelain (LGIT-IRD, Grenoble, France)<br/>"
      "Cecile Cornou (LGIT-IRD, Grenoble, France)<br/>"
      "Jacques Deparis (LGIT, Grenoble, France)<br/>"
      "François Dunand (LGIT, Grenoble, France)<br/>"
      "Bertrand Guillier (LGIT-IRD, Grenoble, France)<br/>"
      "Denis Jongmans (LGIT, Grenoble, France)<br/>"
      "Ombeline Meric (ADRGT, Grenoble, France)<br/>"
      "Matthias Orhnberger (IG, Potsdam, Germany)<br/>"
      "Miriam Kristekova (GI, Bratislava, Slovak Republic)<br/>"
      "Hans-Balder Havenith (ULg, Liège, Belgium)<br/>"
      "Donat Fäh (ETH, Zurich, Switzerland)<br/>"
      "Alexandros Savvaidis (ITSAK, Thessaloniki, Greece)<br/>"
      "Estelle Schissele (IG, Potsdam, Germany)<br/>"
      "Frédéric Nguyen (Geomac, Liège, Belgium)<br/>"
      "Giuseppe Di Giulio (INGV, Rome, Italy)<br/>"
      "Andreas Köhler (IG, Potsdam, Germany)<br/>"
      "Corinne Lacave (Resonance, Geneva, Switzerland)<br/>"
      "Ilias Papadopoulos (ITSAK, Thessaloniki, Greece)<br/>"
      "...<br/>"
      "And all the many Geopsy users that kindly forward us interesting suggestions and bug reports.</p>"
    "<p>Icons and graphics:</p>"
    "<p style=\"margin-left: 40px; font-style:italic\">"
      "Dominique Hirigoyen (Domedia, Grenoble, France)<br/>"
      "Marc Wathelet (ISTerre, Grenoble, France)</p>"
    );

/*!
 *  Constructs a GeopsyAbout as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
*/
GeopsyAbout::GeopsyAbout(QWidget *parent, Qt::WindowFlags f)
    : QWidget(parent, f)
{
  TRACE;

  setupUi(this);

  notice->setHtml(QApplication::translate("GeopsyAbout", _noticeContents));

  QString str("Version: ");
  str += GEOPSY_VERSION;
  if(strlen(GEOPSY_DISTRIBUTION)>0) {
    str+=" (";
    str+=GEOPSY_DISTRIBUTION;
    str+=")";
  }
  version->setText(str);
  _painted=false;
}

void GeopsyAbout::paintEvent(QPaintEvent * e)
{
  TRACE;
  // For startup splash screen, last 10 second after first repaint
  if(!parent()) {
    _painted=true;
    QTimer::singleShot(10000, this, SLOT(close()));
  }
  QWidget::paintEvent(e);
}
