/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-02-19
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef FILEVIEW_H
#define FILEVIEW_H

#include <GeopsyGui.h>

class MainWindow;

class FileView : public QTreeView
{
  Q_OBJECT
public:
  FileView(QWidget* parent=0);

  virtual QSize sizeHint() const;

  SignalFileItem * model() const;
  void addActions();

  void beginReset();
  void endReset();
  void beginAddFile();
  void endAddFile();
public slots:
  void getSelection(SubSignalPool& sel);

  SubPoolWindow * newTableWindow();
  SubPoolWindow * newGraphicWindow();
  SubPoolWindow * newMapWindow();
  SubPoolWindow * newChronogramWindow();
  void newTool();
  void remove();
  void copyPath();
protected:
  virtual void contextMenuEvent (QContextMenuEvent * e);
  virtual void mouseDoubleClickEvent (QMouseEvent * e);

  QAction * _graphicAction;
  QAction * _tableAction;
  QAction * _mapAction;
  QAction * _chronogramAction;

  QMenu * _menu;
};

#endif // FILEVIEW_H
