/***************************************************************************
**
**  This file is part of dinvermatlab.
**
**  This file is distributed under the terms of the Geopsy.org Commercial
**  License appearing in the file LICENSE.COMMERCIAL included in the packaging
**  of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See Geopsy.org Commercial License for
**  more details.
**
**  You should have received a copy of the Geopsy.org Commercial License
**  along with this program. If not, see <http://www.geopsy.org>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-11-23
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MATLABPLUGIN_H
#define MATLABPLUGIN_H

#include <DinverGui.h>

#include "dinvermatlabInstallPath.h"

class MatlabTargetWidget;
class MatlabTarget;
class MatlabInversion;

class MatlabPlugin : public DinverInterface
{
  Q_OBJECT
#if(QT_VERSION > QT_VERSION_CHECK(5, 0, 0))
  Q_PLUGIN_METADATA(IID "org.geopsy.dinverInterface")
#endif
  Q_INTERFACES(DinverCore::DinverInterface)
public:
  MatlabPlugin();
  ~MatlabPlugin();

  virtual DinverInterface * clone();

  virtual QString tag() const;
  virtual QString title() const ;
  virtual QString version() const ;
  virtual QString description() const ;

  virtual QWidget * createTargetWidget();
  virtual QWidget * createParamWidget();

  virtual bool xmlSupport() const {return true;}
  virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
  virtual bool xml_polishChild(XML_POLISHCHILD_ARGS);
  virtual const char * interfaceVersion() const {return DINVERCORE_VERSION;}

  virtual AbstractForward * createForward();
  virtual bool initForward(AbstractForward * forward);
  virtual void setCurrentForward(AbstractForward * forwards, const QString& );
private slots:
  void checkScript();
private:
  ParamSpaceEditor * _paramWidget;
  MatlabTargetWidget * _targetWidget;
  // Global and batch definition of parameters and target
  // Null when global selection is active
  ParamSpaceScript * _param;
  MatlabTarget * _target;
  MatlabInversion * _currentRun;
};

#endif // MATLABPLUGIN_H
