/***************************************************************************
**
**  This file is part of dinverdc.
**
**  dinverdc is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinverdc is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-11-08
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "RingBrowser.h"

/*!
  \class RingBrowser RingBrowser.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
RingBrowser::RingBrowser(QWidget * parent)
    : QWidget(parent)
{
  TRACE;
  setupUi(this);
}

/*!
  Description of destructor still missing
*/
RingBrowser::~RingBrowser()
{
  TRACE;
}

void RingBrowser::setCurrent(int index)
{
  TRACE;
  currentRing->setCurrentIndex(index);
}

int RingBrowser::current() const
{
  TRACE;
  return currentRing->currentIndex();
}

int RingBrowser::indexOf(const AutocorrRing& ring)
{
  TRACE;
  for(int i=_rings.count() - 1; i >= 0;i-- ) {
    if(_rings.at(i)==ring) {
      return i;
    }
  }
  return -1;
}

void RingBrowser::setRing(int index, const AutocorrRing& ring)
{
  TRACE;
  _rings[index]=ring;
  blockSignals(true);
  minRadiusEdit->setValue(ring.minRadius());
  maxRadiusEdit->setValue(ring.maxRadius());
  blockSignals(false);
  setName(index);
}

void RingBrowser::on_currentRing_currentIndexChanged(int index)
{
  TRACE;
  if(index>=0 && index < _rings.count()) {
    minRadiusEdit->blockSignals(true);
    maxRadiusEdit->blockSignals(true);
    minRadiusEdit->setValue(_rings.at(index).minRadius());
    maxRadiusEdit->setValue(_rings.at(index).maxRadius());
    minRadiusEdit->blockSignals(false);
    maxRadiusEdit->blockSignals(false);
    emit currentChanged(index);
  }
}

void RingBrowser::on_addRingBut_clicked()
{
  TRACE;
  add();
}

void RingBrowser::add()
{
  TRACE;
  int index=_rings.count();
  _rings.append(AutocorrRing());
  if(index==0) setEnabled(true);
  emit added(index);
  QString str=name(index);
  currentRing->addItem(str);
  if(index>0) setCurrent(index);
  emit nameChanged(index, str);
}

void RingBrowser::on_removeRingBut_clicked()
{
  TRACE;
  int index=currentRing->currentIndex();
  int n=_rings.count() -1;
  _rings.remove(index);
  emit removed(index);
  currentRing->removeItem(index);
  for(int i=index; i<n; i++ ) {
    setName(i);
  }
  if(n==0) setEnabled(false);
}

void RingBrowser::on_minRadiusEdit_valueChanged(double val)
{
  TRACE;
  int index=currentRing->currentIndex();
  double maxValue=maxRadiusEdit->value(_rings[index].maxRadius());
  if(val<=maxValue) _rings[index].setRadii(val, maxValue);
  setName(index);
}

void RingBrowser::on_maxRadiusEdit_valueChanged(double val)
{
  TRACE;
  int index=currentRing->currentIndex();
  double minValue=minRadiusEdit->value(_rings[index].minRadius());
  if(val>=minValue) _rings[index].setRadii(minValue, val);
  setName(index);
}

void RingBrowser::clear()
{
  TRACE;
  _rings.clear();
  currentRing->clear();
  setEnabled(false);
}

QString RingBrowser::name(int index)
{
  TRACE;
  const AutocorrRing& r=_rings.at(index);
  return tr("Ring %1 from %2 m to %3 m").arg(index+1).arg(r.minRadius()).arg(r.maxRadius());
}

void RingBrowser::setName(int index)
{
  TRACE;
  QString str=name(index);
  currentRing->setItemText(index, str);
  emit nameChanged(index, str);
}

void RingBrowser::setEditable(bool e)
{
  TRACE;
  addRingBut->setEnabled(e);
  if(_rings.count()>0) setEnabled(e);
}

void RingBrowser::setEnabled(bool e)
{
  TRACE;
  removeRingBut->setEnabled(e);
  minRadiusEdit->setEnabled(e);
  maxRadiusEdit->setEnabled(e);
  toLabel->setEnabled(e);
  fromLabel->setEnabled(e);
  currentRing->setEnabled(e);
}
