/***************************************************************************
**
**  This file is part of dinver.
**
**  dinver is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinver is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-10-19
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef InversionThread_H
#define InversionThread_H

#include <DinverCore.h>

class InversionThread : public Thread, public XMLClass
{
  Q_OBJECT
public:
  InversionThread(QObject * parent=nullptr);
  ~InversionThread();

  virtual const QString& xml_tagName() const {return xmlInversionThreadTag;}
  static const QString xmlInversionThreadTag;

  bool operator==(const InversionThread& o) const {return _models==o._models;}
  bool operator!=(const InversionThread& o) const {return !(_models==o._models);}

  bool setForward(AbstractForward * forward);
  void setStorage();
  bool setObjectName(QString name);
  bool setReportDir(const QDir& d);
  QDir reportDir() const;
  bool isReportExists() const {QFileInfo fi(_reportFileName); return fi.exists();}
  bool hasModelsToImport() const {return _hasModelsToImport;}
  void checkImportModels();
  void importModels(QString fileName, bool strict=true);
  QString reportFileName() const {return _reportFileName;}
  void removeFiles(bool reportOnly);

  void start();
  void terminate();
  void clear();

  void setImportOnly() {_importOnly=true;}
  void setNs0(int ns0) {_ns0=ns0;}
  void setNs(int ns) {_ns=ns;}
  void setNr(int nr) {_nr=nr;}
  void setNw(int nw) {_nw=nw;}
  void setGiveUp(double giveUp) {_giveUp=giveUp;}

  int ns0() const {return _ns0;}
  int ns() const {return _ns;}
  int nr() const {return _nr;}
  int nw() const {return _nw;}
  double giveUp() const {return _giveUp;}
  void setTuningParameters(InversionThread * t);

  void lock() const {_models.lock();}
  void unlock() const {_models.unlock();}

  int expectedModelCount() const {return _models.expectedModelCount();}
  int visitedModelCount() const {return _models.visitedModelCount();}
  int validModelCount() const;
  int activeModelCount() const {return _models.activeModelCount();}
  int rejectedCount() const {return _models.rejectedCount();}
  int giveUpCount() const {return _models.giveUpCount();}
  int bestModelCount() const {return _models.bestModelCount();}
  int variableParameterCount() const {return _models.variableParameterCount();}
  double reportBestMisfit() const {return _reportBestMisfit;}

  double misfit(int modelIndex) const {return _models.misfit(modelIndex);}
  AbstractForward * forward() {return _models.forward();}
  const Parameter * variableParameter(int paramIndex) const {return _models.variableParameter(paramIndex);}
  double variableParameterValue(int modelIndex, int paramIndex) const {return _models.variableParameterValue(modelIndex, paramIndex);}
signals:
  void started();
  void stopped();
protected:
  virtual void run();

  virtual void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
  virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
  virtual bool xml_setProperty(XML_SETPROPERTY_ARGS);
  virtual bool xml_polish(XML_POLISH_ARGS);
private:
  void renameFiles(QDir &d, const QString& oldName);
  void importModelsFromAscii(QString fileName);
  void importModelsFromReport(QString fileName, bool strict);

  int _ns0, _ns, _nr, _nw, _itmax;
  double _giveUp;
  QString _reportFileName;
  bool _importOnly;
  bool _hasModelsToImport;
  int _reportValidModelCount;
  double _reportBestMisfit;

  ModelRepository _models;
};

#endif
