/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2017-01-26
**  Copyright: 2017-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "SheetSelectionWidget.h"
#include "GraphicSheet.h"

namespace SciFigs {

  /*!
    \class SheetSelectionWidget SheetSelectionWidget.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  SheetSelectionWidget::SheetSelectionWidget(QWidget * parent)
    : QWidget(parent)
  {
    TRACE;
    setAttribute(Qt::WA_TransparentForMouseEvents, true);
  }

  /*!
    Description of destructor still missing
  */
  SheetSelectionWidget::~SheetSelectionWidget()
  {
    TRACE;
  }

  void SheetSelectionWidget::paintEvent(QPaintEvent *)
  {
    TRACE;
    GraphicSheet * sheet=static_cast<GraphicSheet *>(parent());
    QPainter p;
    p.begin(this);
    if(sheet->isMouseTrackingActive()) {
      p.setPen(Qt::DotLine);
      QPoint topLeft=sheet->mouseTrackingRect().topLeft();
      topLeft=sheet->widget()->mapToGlobal(topLeft);
      topLeft=mapFromGlobal(topLeft);
      QPoint bottomRight=sheet->mouseTrackingRect().bottomRight();
      bottomRight=sheet->widget()->mapToGlobal(bottomRight);
      bottomRight=mapFromGlobal(bottomRight);
      p.drawRect(QRect(topLeft, bottomRight));
    }
    p.end();
  }

} // namespace SciFigs

