/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-12-03
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>
#include "OrderTip.h"

namespace SciFigs {

OrderTip::OrderTip(QWidget * parent)
  : QWidget((QWidget *)parent)
{
  TRACE;
  QFont f=font();
  f.setBold(true);
  setFont(f);
}

void OrderTip::setIndex(int i)
{
  TRACE;

  QString str=QString::number(i);
  QFontMetrics f(font());
  QRect r=f.boundingRect(0, 0, INT_MAX, INT_MAX, Qt::AlignHCenter | Qt::AlignVCenter, str);
  int w=r.width()+10;
  int h=r.height()+10;
  _pixmap=QPixmap(w,h);
  QPainter p;
  p.begin(&_pixmap);
  p.fillRect(0,0,w,h,Qt::white);
  p.setFont(font());
  p.setBrush(Qt::blue);
  p.setPen(Qt::yellow);
  p.drawRoundedRect(0,0,r.width()+10,r.height()+10,80,80, Qt::AbsoluteSize);
  p.drawText(5,5,r.width(),r.height(), Qt::AlignHCenter | Qt::AlignVCenter,str);
  p.end();  
  resize(w,h);
  setMask(_pixmap.createHeuristicMask(true));
  update();
}

void OrderTip::paintEvent(QPaintEvent * e)
{
  TRACE;
  const QRect& r=e->rect();
  QPainter p(this);
  p.drawPixmap(r.left(),r.top(), _pixmap,r.left(),r.top(),r.width(),r.height());
}


} // namespace SciFigs
