/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-07-04
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef NAMELINELAYERPROPERTIES_H
#define NAMELINELAYERPROPERTIES_H

#include <QGpGuiTools.h>
#include "ui_NameLineLayerProperties.h"

namespace SciFigs {

class NameLineLayer;

class NameLineLayerProperties : public PropertyWidget, private Ui::NameLineLayerProperties
{
  Q_OBJECT
public:
  NameLineLayerProperties(QWidget * parent=nullptr);
  ~NameLineLayerProperties();

  void addLayer(NameLineLayer * layer);
  void removeLayer(NameLineLayer * layer);

  NameLineLayer * currentLayer() const;

  enum Properties {ShowNames, Font};
private:
  virtual PropertyValue::WidgetType determineCustomWidgetType(int pid, QWidget * w, QWidget * label);
  virtual bool connectCustomWidget(PropertyValue & p);
  virtual bool setCustomWidget(PropertyValue & p);
  virtual QVariant customWidgetValue(PropertyValue & p);
  void setLayerList();
  static bool layerLessThan(const NameLineLayer * l1, const NameLineLayer * l2);
private slots:
  void on_fontEdit_clicked();
  void on_currentLayerCombo_currentIndexChanged(int index);
  void applyAllSelected();
private:
  QFont _font;
  QSet<NameLineLayer *> _layerSet;
  QList<NameLineLayer *> _layerList;
};

} // namespace SciFigs

#endif // NAMELINELAYERPROPERTIES_H
