/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-01-31
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>
#include "MouseTracking.h"

namespace SciFigs {

/*!
  \class MouseTracking MouseTracking.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  \fn MouseTracking::MouseTracking()
  Description of constructor still missing
*/

/*!
  \fn MouseTracking::~MouseTracking()
  Description of destructor still missing
*/

void MouseTracking::add(const LayerMouseTracking& l)
{
  TRACE;
  QList<LayerMouseTracking>::prepend(l);
}

void MouseTracking::remove(int i)
{
  TRACE;
  const LayerMouseTracking& l=at(i);
  bool checkRect=l.rectangle();
  QList<LayerMouseTracking>::removeAt(i);
  if(checkRect && _rectangle) {  // check if remaining layers that need rectangle
    for(iterator it=begin(); it!=end(); it++ ) {
      if(it->rectangle()) return;
    }
    delete _rectangle;
    _rectangle=0;
  }
}

int MouseTracking::indexOf(const GraphContentLayer * layer, int id) const
{
  TRACE;
  int n=count();
  for(int i=0; i<n; i++ ) {
    const LayerMouseTracking& l=at(i);
    if(l.layer()==layer && l.id()==id) return i;
  }
  return -1;
}

/*!
  Returns true if the front tracking layer is a rectangle
*/
bool MouseTracking::isRectangle() const
{
  TRACE;
  if(isEmpty()) return false;
  return first().rectangle();
}

/*!
  Returns true if the front tracking layer is a visible rectangle
*/
bool MouseTracking::isRectangleVisible() const
{
  TRACE;
  if(isEmpty()) return false;
  return first().isRectangleVisible();
}

/*!
  Return pen of the front tracking layer
*/
QPen MouseTracking::pen() const
{
  TRACE;
  if(isEmpty()) return QPen();
  return first().pen();
}

/*!
  Return pen of the front tracking layer
*/
QBrush MouseTracking::brush() const
{
  TRACE;
  if(isEmpty()) return QBrush();
  return first().brush();
}

void MouseTracking::initRectangle(const QPoint& topLeft)
{
  TRACE;
  delete _rectangle;
  _rectangle=new QRect;
  _rectangle->moveTopLeft(topLeft);
}

void MouseTracking::resetRectangle()
{
  TRACE;
  delete _rectangle;
  _rectangle=0;
}

} // namespace SciFigs
