/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-10-18
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef LIVECURVELAYER_H
#define LIVECURVELAYER_H

#include "LineLayer.h"
#include "AutoAdjustScale.h"
#include "SciFigsDLLExport.h"

namespace SciFigs {

  class Axis;

  class SCIFIGS_EXPORT LiveCurveLayer : public LineLayer, public AutoAdjustScale
  {
    Q_OBJECT
  public:
    LiveCurveLayer(AxisWindow * parent);
    ~LiveCurveLayer();

    enum Variables {X, Y, Z};

    void setFunction(AbstractFunction * f);
    AbstractFunction * takeFunction();
    const AbstractFunction * function() const {return _function;}

    void setVariables(Variables v) {_variables=v;}
    Variables variables() const {return _variables;}

    void setFixedVariable1(double v) {_fixedVariable1=v;}
    double fixedVariable1() const {return _fixedVariable1;}

    void setFixedVariable2(double v) {_fixedVariable2=v;}
    double fixedVariable2() const {return _fixedVariable2;}

    void setSampling(int s) {_sampling=s;}
    int sampling() const {return _sampling;}

    virtual bool hasProperties() {return true;}
    virtual void addProperties(PropertyProxy * pp);
    virtual void removeProperties(PropertyProxy * pp);
    virtual void properties(PropertyWidget * w) const;
    virtual void setProperty(uint wid, int pid, QVariant val);

    virtual Rect boundingRect() const;
  signals:
    void scaleChanged(double min, double max, Axis * a) const;
  private slots:
    void adjustScale(double min, double max, Axis * a) const;
  protected:
    virtual void paintData(const LayerPainterRequest& lp, QPainter& p, double dotpercm) const;
    virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;

    AbstractFunction * _function;
    int _sampling;
  private:
    Curve<Point2D> calculateCurve(const QSize& s, const GraphContentOptions& gc,
                                  const LayerPainterRequest * lp=nullptr) const;

    double _fixedVariable1, _fixedVariable2;
    Variables _variables;
    mutable double _min, _max;
    static uint _tab;
  };

} // namespace SciFigs

#endif // LIVECURVELAYER_H

