/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-04-27
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef LEGENDWIDGET_H
#define LEGENDWIDGET_H

#include "GraphicObject.h"
#include "Legend.h"
#include "SciFigsGlobal.h"
#include "SciFigsDLLExport.h"
#include "Font.h"

namespace SciFigs {

class LegendProperties;
class LegendEditor;

class SCIFIGS_EXPORT LegendWidget : public GraphicObject
{
  Q_OBJECT
  // Compatibility
  Q_PROPERTY(double lineWidth READ dummyPropertyDouble WRITE setLineSize STORED false)

  Q_PROPERTY(QString title READ title WRITE setTitle SCRIPTABLE true)
  Q_PROPERTY(double lineSize READ lineSize WRITE setLineSize SCRIPTABLE true)
  Q_PROPERTY(QString font READ fontString WRITE setFont SCRIPTABLE true)
  Q_PROPERTY(bool adjustBox READ adjustBox WRITE setAdjustBox SCRIPTABLE true)
public:
  LegendWidget(QWidget *parent=nullptr, Qt::WindowFlags f=Qt::Widget);
  ~LegendWidget();

  LegendWidget& operator=(const LegendWidget& o);

  virtual const QString& xml_tagName() const {return xmlLegendWidgetTag;}
  static const QString xmlLegendWidgetTag;

  void resize(int n) {_legend.resize(n);}

  QString title() const {return _title;}
  void setTitle(const QString& t);

  QString fontString() const {return _font.toString();}
  void setFont(const QFont& f);
  void setFont(const QString& f);

  double lineSize() const {return _lineSize;}
  void setLineSize(double ls);

  bool adjustBox() const {return _adjustBox;}
  void setAdjustBox(bool t);

  const Legend& legend() const {return _legend;}
  Legend& legend() {return _legend;}

  virtual void addProperties(PropertyProxy * pp);
  virtual void removeProperties(PropertyProxy * pp);
  virtual void properties(PropertyWidget * w) const;
  virtual void setProperty(uint wid, int pid, QVariant val);
public slots:
  void load(QString fileName);
  void save(QString fileName);
  virtual void showProperties() {GraphicObject::showProperties(_category);}
protected:
  virtual void paint(QPainter& p, double dotpercm,int w, int h, bool mask);
  virtual void setPrintSize(double dotpercm);
private:
  void adjustSize();
  void adjustSize(double dotpercm, int& width, int& height);

  Legend _legend;
  Font _font;
  QString _title;
  double _lineSize;
  bool _adjustBox;
  static uint _category, _tabLegend, _tabFormat;
signals:
  void changed(Legend leg);
protected:
  XMLMember xml_member(XML_MEMBER_ARGS);
  void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  virtual bool xml_setProperty(XML_SETPROPERTY_ARGS);
};

} // namespace SciFigs

#endif // LEGENDWIDGET_H
