/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-06-22
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>

#include "MultiDocumentSubWindow.h"
#include "MultiDocumentTab.h"
#include "Settings.h"

namespace QGpGuiTools {

  /*!
    \class MultiDocumentSubWindow MultiDocumentSubWindow.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  MultiDocumentSubWindow::MultiDocumentSubWindow(QWidget * parent, Qt::WindowFlags flags)
      : QMdiSubWindow(parent, flags)
  {
    TRACE;
    setAttribute(Qt::WA_DeleteOnClose, true);
    _windowMenuAction=new QAction(this);
    _windowMenuAction->setCheckable(true);
    connect(_windowMenuAction, SIGNAL(triggered()), this, SLOT(windowsMenuTriggered()));

    QMenu * wm=systemMenu();
    QMenu * m=new QMenu("Move to tab", this);
    connect(m, SIGNAL(aboutToShow()), this, SLOT(moveToTabMenu()));
    wm->insertMenu(wm->actions().first(), m);

    _userClosable=true;
  }

  /*!
    Description of destructor still missing
  */
  MultiDocumentSubWindow::~MultiDocumentSubWindow()
  {
    TRACE;
  }

  void MultiDocumentSubWindow::setWindowTitle(const QString& t)
  {
    TRACE;
    QMdiSubWindow::setWindowTitle(t);
    if(t.length()>35) { // Test to eventually remove
      _windowMenuAction->setText(t.left(35)+"...");
    } else {
      _windowMenuAction->setText(t);
    }
  }

  void MultiDocumentSubWindow::setWindowIcon(const QIcon & icon)
  {
    TRACE;
    QMdiSubWindow::setWindowIcon(icon);
    _windowMenuAction->setIcon(icon);
  }

  void MultiDocumentSubWindow::show()
  {
    TRACE;
    QMdiArea * a=mdiArea();
    if(a->activeSubWindow() && a->activeSubWindow()->isMaximized()) {
      showMaximized();
    } else {
      QMdiSubWindow::show();
    }
  }

  void MultiDocumentSubWindow::windowsMenuTriggered()
  {
    TRACE;
    MultiDocumentTab * t=tab();
    t->activate();
    t->setActiveSubWindow(this);
    show(); // In case widget was hidden
  }

  void MultiDocumentSubWindow::moveToTabMenu()
  {
    TRACE;
    emit(moveToTabMenuRequested(qobject_cast<QMenu *>(sender()), this));
  }

  MultiDocumentTab * MultiDocumentSubWindow::tab() const
  {
    TRACE;
    return static_cast<MultiDocumentTab *>(mdiArea());
  }

  void MultiDocumentSubWindow::closeEvent(QCloseEvent * e)
  {
    TRACE;
    if(_userClosable) {
      QString name;
      if(widget()) {
        name=widget()->objectName();
      } else {
        name=objectName();
      }
      if(widget()->close()) {
        Settings::setSize(this, name);
        e->accept();
      } else {
        e->ignore();
      }
    } else {
      e->ignore();
    }
  }

} // namespace QGpGuiTools
