/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-11-04
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "LogWidget.h"
#include "LogView.h"
#include "Application.h"

namespace QGpGuiTools {

  LogWidget::LogWidget(QWidget * parent)
      : QWidget(parent)
  {
    TRACE;
    vboxLayout=new QVBoxLayout(this);
    vboxLayout->setMargin(0);
    vboxLayout->setObjectName(tr("vboxLayout"));
    logTab=new QTabWidget(this);
    logTab->setObjectName(tr("logTab"));
    logTab->setTabPosition(QTabWidget::South);
    logTab->setTabShape(QTabWidget::Triangular);
    logTab->setUsesScrollButtons (true);
    vboxLayout->addWidget(logTab);

    _debugMode=false;
  }

  LogWidget::~LogWidget()
  {
    TRACE;
    for(int i=logTab->count()-1; i>=0; i--) {
      static_cast<LogView *>(logTab->widget(i))->remove();
      logTab->removeTab(i);
    }
  }

  QString LogWidget::text(QThread * t) const
  {
    TRACE;
    AbstractStream * as=Application::instance()->stream(t);
    if(as->classId()==AbstractStream::LogViewId) {
      LogView * s=static_cast<LogView *>(as);
      if(s) {
        s->flushBuffer();
        return s->toPlainText();
      }
    }
    return QString();
  }

  LogView * LogWidget::addView(QThread * t, QString label)
  {
    TRACE;
    if(_debugMode) {
      Application::instance()->setStream(new StandardStream(stdout) , t);
      return 0;
    } else {
      LogView * s=new LogView;
      logTab->addTab(s, label);
      Application::instance()->setStream(s , t);
      return s;
    }
  }

  void LogWidget::removeView(QThread * t)
  {
    TRACE;
    AbstractStream * as=Application::instance()->stream(t);
    if(as->classId()==AbstractStream::LogViewId) {
      LogView * s=static_cast<LogView *>(as);
      LogView::removeReference(s);
      int tabIndex=logTab->indexOf(s);
      logTab->removeTab(tabIndex);
    }
  }

  void LogWidget::setViewName(QThread * t, QString label)
  {
    TRACE;
    AbstractStream * as=Application::instance()->stream(t);
    if(as->classId()==AbstractStream::LogViewId) {
      LogView * s=static_cast<LogView *>(as);
      int tabIndex=logTab->indexOf(s);
      if(tabIndex>-1) {
        logTab->setTabText(tabIndex, label);
      }
    }
  }

} // namespace QGpGuiTools
