/***************************************************************************
**
**  This file is part of QGpCoreWave.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-10-15
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>
#include "ShAmplification.h"
#include "Seismic1DModel.h"

namespace QGpCoreWave {

/*!
  \class ShAmplification ShAmplification.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Kennett method for computation of transfert function
  TODO use the same code as in gpsh
*/
Curve<Point2D> ShAmplification::curve(int fcount, double fmax, float theta)
{
  // This first version use a code in fortran to calculate the transfert function
  float *fr, *u1, *v1, *w3, *al0, *be0, *dens, *th, *qp, *qs, ffmax;
  fr=new float[fcount];
  u1=new float[fcount];
  v1=new float[fcount];
  w3=new float[fcount];
  al0=new float[_model->layerCount()];
  be0=new float[_model->layerCount()];
  dens=new float[_model->layerCount()];
  th=new float[_model->layerCount()];
  qp=new float[_model->layerCount()];
  qs=new float[_model->layerCount()];
  ffmax=fmax;
  // Copy model parameter in appropriate float vectors
  for(int i=0;i<_model->layerCount();i++) {
    if(i<_model->layerCount()-1) th[i]=_model->h(i); else th[i]=1;
    al0[i]=1.0/_model->slowP(i);
    be0[i]=1.0/_model->slowS(i);
    dens[i]=_model->rho(i);
    qp[i]=_model->qp(i);
    qs[i]=_model->qs(i);
  }
  // Compute site response
  //long nl=_model->layerCount();
  //qtbFortran.kensh(&nl, &theta, &ffmax, &fcountl, al0, be0, dens, th, qp, qs, fr, u1, v1,w3);
  // Get fr and u1 in a list of point_2D
  Curve<Point2D> c(fcount);
  for(int i=0;i<fcount;i++) {
    Point2D& p=c[i];
    p.setX(Number::toDouble(fr[i] ));
    p.setY(Number::toDouble(u1[i] ));
  }
  delete [] fr;
  delete [] u1;
  delete [] v1;
  delete [] w3;
  delete [] al0;
  delete [] be0;
  delete [] dens;
  delete [] th;
  delete [] qp;
  delete [] qs;
  return c;
}

} // namespace QGpCoreWave
