/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2003-12-15
**  Copyright: 2003-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef STATCOMPARATOR_H
#define STATCOMPARATOR_H

#include <QGpCoreTools.h>

#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

class QGPCOREMATH_EXPORT StatComparator
{
public:
  StatComparator() {}
  ~StatComparator() {}

  static inline double student(double t, double nu);
  static inline double fisher(double F, double nu1, double nu2);
  static double invStudent(double p, double nu);
  static double invFisher(double p, double nu1, double nu2);
protected:
  static double betai(double a, double b, double x);
  static double gammln(double x);
  static double betacf(double a, double b, double x);
};

/**
  Student's ditribution probability function
  (Numerical Recipes chapter 6.4)
  We calculate the function A(t|nu)
  */
inline double StatComparator::student(double t, double nu)
{
  TRACE;
  return betai(nu/2.0, 0.5, nu/(nu + t * t));
}

/**
  F ditribution probability function
  (Numerical Recipes chapter 6.4)
  We calculate the function Q(F|nu1, nu2)
  */
inline double StatComparator::fisher(double F, double nu1, double nu2)
{
  TRACE;
  return betai(nu2/2.0, nu1/2.0, nu2/(nu2 + nu1 * F));
}

} // namespace QGpCoreMath

#endif // STATCOMPARATOR_H
