/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-12-19
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef PERMUTATIONVECTOR_H
#define PERMUTATIONVECTOR_H

#include <QtCore>

#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT PermutationVector : private QVector<int>
  {
  public:
    PermutationVector(int n) : QVector<int>(n) {}
    PermutationVector(const PermutationVector& o) : QVector<int>(o) {}

    int newIndex(int oldIndex) const {return at(oldIndex);}
    void setNewIndex(int oldIndex, int newIndex) {operator[](oldIndex)=newIndex;}

    PermutationVector inverted();

    QString toString() const;
  };

} // namespace QGpCoreMath

#endif // PERMUTATIONVECTOR_H
