/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-01-13
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef COMPLEXMPMATRIX_H
#define COMPLEXMPMATRIX_H

#include <QGpCoreTools.h>

#ifdef MULTI_PRECISION

#include "ComplexMatrix.h"
#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT ComplexMPMatrix : public Matrix<ComplexMP>
  {
  public:
    ComplexMPMatrix(int nbits) : Matrix<ComplexMP>() {_precision=nbits;}
    ComplexMPMatrix(int nbits, int nrow, int ncol) : Matrix<ComplexMP>(nrow, ncol) {setPrecision(nbits);}

    void setPrecision(int nbits);
    void resize(int ndim);
    void resize(int nrow, int ncol);

    void rand();

    template <class T1, class T2>
    void multiply(const Matrix<T1>& m1, const Matrix<T2>& m2);

    void operator=(const ComplexMatrix& o);
  private:
    int _precision;
  };

  template <class T1, class T2>
  void ComplexMPMatrix::multiply(const Matrix<T1>& m1, const Matrix<T2>& m2)
  {
    ASSERT(m1.columnCount()==m2.rowCount());
    int nrow1=m1.rowCount();
    int ncol1=m1.columnCount();
    int ncol2=m2.columnCount();
    resize(nrow1, ncol2);
    zero(ComplexMP::null);
    ComplexMP * rValues=values();
    const T1 * values1=m1.values();
    const T2 * values2=m2.values();
    int mIndex;
    ComplexMP p(_precision);
    for(int i=0; i<nrow1; i++) {
      for(int j=0; j<ncol2; j++) {
        ComplexMP& resultValue=rValues[i+j*nrow1];
        mIndex=j*ncol1;
        for(int k=0; k<ncol1; k++) {
          p=values1[i+k*nrow1];
          p*=values2[k+mIndex];
          resultValue+=p;
        }
      }
    }
  }

} // namespace QGpCoreMath

#endif // MULTI_PRECISION
#endif // COMPLEXMPMATRIX_H

