/***************************************************************************
**
**  This file is part of HVGui.
**
**  HVGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2013-02-27
**  Copyright: 2013-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "CategoryGroupItem.h"

namespace HVGui {

  /*!
    \class CategoryGroupItem CategoryGroupItem.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  void CategoryGroupItem::setSignals(const QList<AbstractStation *>& stations)
  {
    TRACE;
    for(QList<AbstractStation *>::const_iterator it=stations.begin(); it!=stations.end(); it++) {
      const StationSignals * s=(*it)->originalSignals();
      int n=s->nComponents();
      for(int i=0; i<n; i++) {
        SubSignalPool subPool=s->originals(i);
        for(SubSignalPool::iterator it=subPool.begin(); it!=subPool.end(); it++) {
          _signals.insert(*it);
        }
      }
    }
  }

  bool CategoryGroupItem::belongsTo(AbstractStation * stat, const AbstractSignalGroup * g)
  {
    TRACE;
    const StationSignals * s=stat->originalSignals();
    int n=s->nComponents();
    for(int i=0; i<n; i++) {
      SubSignalPool subPool=s->originals(i);
      for(SubSignalPool::iterator it=subPool.begin(); it!=subPool.end(); it++) {
        if(!g->contains(*it)) {
          return false;
        }
      }
    }
    return true;
  }

  Qt::ItemFlags CategoryGroupItem::flags(const QModelIndex & index) const
  {
    TRACE;
    if(index.isValid()) {
      AbstractSignalGroup * g=group(index);
      if(g->xml_inherits(DefaultSignalGroup::xmlDefaultSignalGroupTag) ||
         g->xml_inherits(StationGroup::xmlStationGroupTag)) {
        return 0;
      } else {
        SubSignalPool subPool=g->subPool();
        for(SubSignalPool::iterator it=subPool.begin(); it!=subPool.end(); it++) {
          if(!_signals.contains(*it)) {
            return 0;
          }
        }
        return Qt::ItemIsSelectable |
               Qt::ItemIsEnabled;
      }
    } else {
      return 0;
    }
  }

} // namespace HVGui
