/***************************************************************************
**
**  This file is part of GeopsySLink.
**
**  GeopsySLink is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsySLink is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-04-24
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SEEDLINKSTATION_H
#define SEEDLINKSTATION_H

#include <QGpCoreTools.h>
#include "GeopsySLinkDLLExport.h"

namespace GeopsySLink {

class SeedLinkStream;
class SeedLinkServer;

class GEOPSYSLINK_EXPORT SeedLinkStation : public XMLClass, private QList<SeedLinkStream *>
{
public:
  SeedLinkStation(SeedLinkServer * server) {_server=server;}
  ~SeedLinkStation() {clear();}

  virtual const QString& xml_tagName() const {return xmlSeedLinkStationTag;}
  static const QString xmlSeedLinkStationTag;

  static bool lessThan(SeedLinkStation * s1, SeedLinkStation * s2) {return *s1 < *s2;}
  inline bool operator<(const SeedLinkStation& o);

  virtual void xml_attributes(XML_ATTRIBUTES_ARGS) const;
  virtual bool xml_setAttributes(XML_SETATTRIBUTES_ARGS);

  QString name() const {return _name;}
  void setName(QString n) {_name=n;}

  QString network() const {return _network;}
  void setNetwork(QString n) {_network=n;}

  QString description() const {return _description;}
  bool streamCheck() const {return _streamCheck;}

  void addStream(SeedLinkStream * stream) {append(stream);}
  static QRegExp selectorExpression(const QString& streamSelector);
  QList<int> indexOf(QRegExp streamSelector) const;
  int count() const {return QList<SeedLinkStream *>::count();}
  SeedLinkStream * at(int index) const {return QList<SeedLinkStream *>::at(index);}
  SeedLinkServer * server() const {return _server;}
  void clear();
protected:
  virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
private:
  SeedLinkServer * _server;
  QString _name;
  QString _network;
  QString _description;
  bool _streamCheck;
};

inline bool SeedLinkStation::operator<(const SeedLinkStation& o)
{
  TRACE;
  if(_network<o._network) return true;
  else if(_network>o._network) return false;
  else {
    if(_name<o._name) return true;
    else return false;
  }
}

} // namespace GeopsySLink

#endif // SEEDLINKSTATION_H
