/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-06-14
**  Copyright: 2016-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "SparseTimeRangeModel.h"

namespace GeopsyGui {

  /*!
    \class SparseTimeRangeModel SparseTimeRangeModel.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  SparseTimeRangeModel::SparseTimeRangeModel(QObject * parent)
    : QAbstractTableModel(parent)
  {
    TRACE;
    _range=nullptr;
    _rangeMutex=nullptr;
  }

  SparseTimeRangeModel::~SparseTimeRangeModel()
  {
    TRACE;
  }

  void SparseTimeRangeModel::setRange(SparseTimeRange *range, Mutex *mutex)
  {
    TRACE;
    beginResetModel();
    _range=range;
    _rangeMutex=mutex;
    endResetModel();
  }

  int SparseTimeRangeModel::rangeCount() const
  {
    if(_range) {
      if(_rangeMutex) {
        QMutexLocker ml(_rangeMutex);
        return _range->ranges().count();
      } else {
        return _range->ranges().count();
      }
    } else {
      return 0;
    }
  }

  int SparseTimeRangeModel::columnCount(const QModelIndex &) const
  {
    TRACE;
    return 3;
  }

  QVariant SparseTimeRangeModel::data(const QModelIndex & index, int role) const
  {
    TimeRange r;
    if(_rangeMutex) {
      QMutexLocker ml(_rangeMutex);
      r=_range->ranges().at(index.row());
    } else {
      r=_range->ranges().at(index.row());
    }
    switch(role) {
    case Qt::DisplayRole:
      switch(index.column()) {
      case 0:
        return r.start().toString();
      case 1:
        return r.end().toString();
      case 2:
        return Number::secondsToDuration(r.lengthSeconds());
      }
    }
    return QVariant();
  }

  QVariant SparseTimeRangeModel::headerData(int section, Qt::Orientation orientation, int role) const
  {
    switch(role) {
    case Qt::DisplayRole:
      if(orientation==Qt::Vertical) {
        return section+1;
      } else {
        switch(section) {
        case 0:
          return tr("Start");
        case 1:
          return tr("End");
        case 2:
          return tr("Duration");
        }
      }
    default:
      return QVariant();
    }
  }

  void SparseTimeRangeModel::beginAddRange(int index)
  {
    beginInsertRows(QModelIndex(), index, index);
  }

  void SparseTimeRangeModel::endAddRange()
  {
    endResetModel();
  }

  void SparseTimeRangeModel::beginClearRange()
  {
    beginResetModel();
  }

  void SparseTimeRangeModel::endClearRange()
  {
    endResetModel();
  }

} // namespace GeopsyGui
