/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2003-09-17
**  Copyright: 2003-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>
#include "TimeRange.h"

namespace GeopsyCore {

  // Automatic registration of TimeRange upon loading of the library
  REGISTER_METATYPE(TimeRange)

  /*!
    \class TimeRange TimeRange.h

  */

  /*!
    \fn TimeRange::TimeRange(double start, double end)
  */

  /*!
    \fn bool TimeRange::intersection(TimeRange& tw) const
    Return true if this window has an intersection with \a tw, \a tw is modified to match the intersection
    of this window and \a tw.

    \sa intersect()
  */

  /*!
    \fn bool TimeRange::intersect(const TimeRange& tw) const
    Return true if this window has an intersection with \a tw.

    \sa intersection()
  */

  /*!
    \fn void TimeRange::round(const DateTime& rt, double period, double frequency)

    Round start and end to match \a t0 and sampling \a period.
    \a frequency must be the exact inverse of \a period.
  */

  /*!
    \fn void TimeRange::round(double t0, double period)

    Convenient function
    \sa TimeRange::round(const DateTime& rt, double period, double frequency)
  */

  /*!
    \fn void TimeRange::setStart(const DateTime& t)

    Sets start time. No control between start and end is performed.
  */

  /*!
    \fn void TimeRange::setEnd(const DateTime& t)

    Sets end time. No control between start and end is performed.
  */

  QString TimeRange::toString() const
  {
    return _start.toString()+" "+_end.toString();
  }

  void TimeRange::printDebug() const
  {
    TRACE;
    printf("Range from %s to %s\n", start().toString().toLatin1().data(),
                                    end().toString().toLatin1().data());
  }

} // namespace GeopsyCore
