/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-08-06
**  Copyright: 2010-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef GEOPSYCOREINTERFACE_H
#define GEOPSYCOREINTERFACE_H

#include <QGpCoreTools.h>

#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

class GEOPSYCORE_EXPORT GeopsyCoreInterface : public QObject
{
  Q_OBJECT
public:
  virtual ~GeopsyCoreInterface() {}

  virtual QString tag() const=0;
  virtual QString title() const=0;
  virtual QString description() const;

  virtual void polish() {}

  bool isValid() const;
  virtual const char * interfaceVersion() const=0 ;
};

} // namespace GeopsyCore

Q_DECLARE_INTERFACE(GeopsyCore::GeopsyCoreInterface, "org.geopsy.geopsyInterface")

#endif // GEOPSYCOREINTERFACE_H
