/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-04-11
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef FASTFOURIERTRANSFORM_H
#define FASTFOURIERTRANSFORM_H

#include <QGpCoreTools.h>

#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

class GEOPSYCORE_EXPORT FastFourierTransform
{
public:
  FastFourierTransform();
  virtual ~FastFourierTransform() {}

  virtual void forward(int nSamples, double * samples)=0;
  virtual void backward(int nSamples, double * samples)=0;

  virtual void forward(int nSamples, Complex * samples)=0;
  virtual void backward(int nSamples, Complex * samples)=0;

  virtual void manyForward(int howmany, int nSamples, Complex * samples)=0;
  virtual void manyBackward(int howmany, int nSamples, Complex * samples)=0;

  static FastFourierTransform * instance() {return _self;}
private:
  static FastFourierTransform * _self;
};

} // namespace GeopsyCore

#endif // FASTFOURIERTRANSFORM_H
