/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-04-09
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef FFTW_H
#define FFTW_H

#include "FastFourierTransform.h"

namespace GeopsyCore {

  class FFTW : public FastFourierTransform
  {
  public:
    virtual void forward(int nSamples, double * samples);
    virtual void backward(int nSamples, double * samples);

    virtual void forward(int nSamples, Complex * samples);
    virtual void backward(int nSamples, Complex * samples);

    virtual void manyForward(int howmany, int nSamples, Complex * samples);
    virtual void manyBackward(int howmany, int nSamples, Complex * samples);

    bool loadWisdom(QString fileName);
  private:
    static Mutex _plannerMutex;
  };

} // namespace GeopsyCore

#endif // FFTW_H
