/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-07-15
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ABSTRACTFILEFORMAT_H
#define ABSTRACTFILEFORMAT_H

#include <QGpCoreTools.h>

#include "SignalFileFormat.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

  class SignalFile;
  class Signal;
  class SubSignalPool;

  class GEOPSYCORE_EXPORT AbstractFileFormat: public XMLClass, public SharedObject
  {
    TRANSLATIONS("AbstractSignalFormat")
  public:
    AbstractFileFormat();
    AbstractFileFormat(const AbstractFileFormat& o);
    virtual ~AbstractFileFormat();

    virtual void operator=(const AbstractFileFormat& o);

    void setName(QString n);
    const QString& name() const {return _name;}

    void setCaption(const QString& c) {_caption=c;}
    const QString& caption() const {return _caption;}
    QString captionFilter() const;

    void clearSuffixList() {_suffixList.clear();}
    void addSuffix(QString s);
    void addSuffixList(const QString& sl);
    const QStringList& suffixList() const {return _suffixList;}
    QString suffixFilter() const;

    virtual SignalFileFormat::Format format() const {return SignalFileFormat::Custom;}
    virtual int complexity() const {return 0;}
    virtual bool isValid(const QString& /* fileName */) const {return false;}
    virtual bool isReadOnly() const {return true;}
    virtual bool hasUserProperties() const {return false;}
    virtual SignalFileFormat::Storage storage() const {return SignalFileFormat::Multi;}

    virtual bool load(SignalFile * file) const;
    virtual bool load(const Signal * sig, double * samples) const;
    virtual bool save(const SubSignalPool& subpool, const QString& filePath) const;
  protected:
    virtual void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
    virtual XMLMember xml_member(XML_MEMBER_ARGS);
    virtual bool xml_setProperty(XML_SETPROPERTY_ARGS);
  private:
    QString _name;
    QString _caption;
    QStringList _suffixList;
  };

} // namespace GeopsyCore

#endif // ABSTRACTFILEFORMAT_H
