/***************************************************************************
**
**  This file is part of DinverDCCore.
**
**  DinverDCCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverDCCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-07-27
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "ValueTarget.h"

namespace DinverDCCore {

/*!
  \class ValueTarget ValueTarget.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

const QString ValueTarget::xmlValueTargetTag="ValueTarget";

/*!
  Description of constructor still missing
*/
ValueTarget::ValueTarget()
    : Target()
{
  TRACE;
  _value.setWeight(1.0);
  _value.setValid(false);
}

/*!
  Description of constructor still missing
*/
ValueTarget::ValueTarget(const ValueTarget& o)
    : Target(o)
{
  TRACE;
  _value=o._value;
}

void ValueTarget::xml_writeChildren(XML_WRITECHILDREN_ARGS) const
{
  TRACE;
  _value.xml_save(s, context);
}

XMLMember ValueTarget::xml_member(XML_MEMBER_ARGS)
{
  TRACE;
  Q_UNUSED(context)
  if(tag=="RealStatisticalValue" ||
     tag=="StatValue") { // Kept for compatibility <=201005
    return XMLMember(&_value);
  } else return Target::xml_member(tag, attributes, context);
}

} // namespace DinverDCCore
