/***************************************************************************
**
**  This file is part of DinverDCCore.
**
**  DinverDCCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverDCCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-04-02
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PARAM3DGROUNDMODEL_H
#define PARAM3DGROUNDMODEL_H

#include <DinverCore.h>

#include "DinverDCCoreDLLExport.h"

namespace DinverDCCore {

class ParamGroundModel;
class GroundParameter;

class DINVERDCCORE_EXPORT Param3DGroundModel: public XMLClass
{
public:
  Param3DGroundModel();
  Param3DGroundModel(const Param3DGroundModel& o);
  ~Param3DGroundModel();

  virtual const QString& xml_tagName() const {return xmlParam3DGroundModelTag;}
  static const QString xmlParam3DGroundModelTag;

  void addModel(const ParamGroundModel& gm);
  void setCustomConditions(const QString& c) {_customConditions.setText(c);}
  int modelCount() const {return _models.count();}
  ParamGroundModel * model(int index) const {return _models.at(index);}

  void initFinalProfiles();
  void updateFinalProfiles(const GroundParameter * from=0);
  bool toParameters(RealSpace& ps) const;
  bool isValid() const;
  void humanInfo() const;
protected:
  virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
private:
  QVector<ParamGroundModel *> _models;
  ParamSpaceScript _customConditions;
  QHash<const ParamGroundModel *, int> _lookup;
};

} // namespace DinverDCCore

#endif // PARAM3DGROUNDMODEL_H
