/***************************************************************************
**
**  This file is part of DinverCore.
**
**  DinverCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-12-21
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GENERATOR_H
#define GENERATOR_H

#include <QGpCoreMath.h>

#include "DinverCoreDLLExport.h"

namespace DinverCore {

  class ModelRepository;
  class AbstractForward;
  class VoronoiNavigator;
  class NewModel;

  class DINVERCORE_EXPORT Generator : public Thread
  {
  public:
    Generator(ModelRepository * repository,
              AbstractForward * forward,
              int seed);
    ~Generator();

    enum Type {MonteCarlo, Neighborhood};

    void setWalkCount(int n) {_walkCount=n;}
    void setType(Type t) {_type=t;}

    void stop() {_terminated.setValue(true);}
  protected:
    virtual void run();
  private:
    virtual void monteCarloLoop();
    virtual void neighborhoodLoop();
    void monteCarlo(NewModel * newModel);
    void neighborhood(NewModel * newModel);

    AtomicBoolean _terminated;

    Type _type;
    int _walkCount;

    ModelRepository * _repository;
    AbstractForward * _forward;
    Random * _randomNumbers;

    int _generatorModelsSerialNumber;
    VoronoiNavigator * _nav;
  };

} // namespace DinverCore

#endif // GENERATOR_H
