/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-11-29
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef FKWORKER_H
#define FKWORKER_H

#include "ArrayCoreDLLExport.h"
#include "ArrayWorker.h"
#include "FKTaskManager.h"
#include "FKCache.h"
#include "FKGridSearch.h"
#include "FKParameters.h"
#include "FKCrossSpectrum.h"
#include "FKPeaks.h"

namespace ArrayCore {

  class WaveNumberConverter;

  class ARRAYCORE_EXPORT FKWorker : public ArrayWorker
  {
  public:
    FKWorker(const ArraySelection * array,
             const FKParameters * param);
    ~FKWorker();

    void setGrid(FKCache * gridCache);

    void setTaskManager(FKTaskManager * tm) {ArrayWorker::setTaskManager(tm);}
  protected:
    FKTaskManager * taskManager() {return static_cast<FKTaskManager *>(ArrayWorker::taskManager());}

    virtual void process(const QVector<int>& blocks);
    virtual void mergeResults();

    void functions(AbstractFKFunction *& rayleigh, AbstractFKFunction *& love);
    void localizeMax(int gridIndex);
    bool addPeak(int gridIndex, const WaveNumberConverter& conv);
    bool setSlownessRange(int gridIndex);
    FKCrossSpectrum * crossSpectrum() {return static_cast<FKCrossSpectrum *>(_crossSpectrum);}
  private:
    FKGridSearch * createGrid(AbstractFKFunction::Type t, FKCache * gridCache);

    enum GridIndex {RayleighGrid=0, LoveGrid, GridCount};

    FunctionSearch * _grid[2];
    FKPeaks _peaks;
  };

} // namespace ArrayCore

#endif // FKWORKER_H

