/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-01-28
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef FKSTEERINGTWOCOMPONENTRAYLEIGHFIXEDELL_H
#define FKSTEERINGTWOCOMPONENTRAYLEIGHFIXEDELL_H

#include "FKSteering.h"
#include "FKCache.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT FKSteeringTwoComponentRayleighFixedEll : public FKSteering
  {
  public:
    FKSteeringTwoComponentRayleighFixedEll()
      : FKSteering() {}

    void resize() {FKSteering::resize(2*_array->count());}

    void initValue(const Point2D& k);

    static void init(FKCache * cache, int index, const Point2D& k);

    static inline const FKSteeringTwoComponentRayleighFixedEll& cache(const FKCache * cache, int index);
    static inline FKSteeringTwoComponentRayleighFixedEll& cache(FKCache * cache, int index);
  };

  inline const FKSteeringTwoComponentRayleighFixedEll& FKSteeringTwoComponentRayleighFixedEll::cache(const FKCache * cache, int index)
  {
    return static_cast<const FKSteeringTwoComponentRayleighFixedEll&>(cache->steering(FKCache::TwoComponentRayleighFixedEll, index));
  }

  inline FKSteeringTwoComponentRayleighFixedEll& FKSteeringTwoComponentRayleighFixedEll::cache(FKCache * cache, int index)
  {
    return static_cast<FKSteeringTwoComponentRayleighFixedEll&>(cache->steering(FKCache::TwoComponentRayleighFixedEll, index));
  }

} // namespace ArrayCore

#endif // FKSTEERINGTWOCOMPONENTRAYLEIGHFIXEDELL_H

