/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-04-12
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef FKSTEERINGTWOCOMPONENTCONVRAYLEIGH_H
#define FKSTEERINGTWOCOMPONENTCONVRAYLEIGH_H

#include "FKSteering.h"
#include "FKCache.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT FKSteeringTwoComponentConvRayleigh : public FKSteering
  {
  public:
    FKSteeringTwoComponentConvRayleigh()
      : FKSteering() {}

    void resize() {FKSteering::resize(2*_array->count());}

    void initValue(const Point2D& k, double ell);

    static inline const FKSteeringTwoComponentConvRayleigh& cache(const FKCache * cache, int index);
    static inline FKSteeringTwoComponentConvRayleigh& cache(FKCache * cache, int index);
  };

  inline const FKSteeringTwoComponentConvRayleigh& FKSteeringTwoComponentConvRayleigh::cache(const FKCache * cache, int index)
  {
    return static_cast<const FKSteeringTwoComponentConvRayleigh&>(cache->steering(FKCache::TwoComponentRayleigh, index));
  }

  inline FKSteeringTwoComponentConvRayleigh& FKSteeringTwoComponentConvRayleigh::cache(FKCache * cache, int index)
  {
    return static_cast<FKSteeringTwoComponentConvRayleigh&>(cache->steering(FKCache::TwoComponentRayleigh, index));
  }

} // namespace ArrayCore

#endif // FKSTEERINGTWOCOMPONENTCONVRAYLEIGH_H

