/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-04-04
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef FKSTEERING_H
#define FKSTEERING_H

#include <QGpCoreMath.h>

#include "ArraySelection.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class FKPower;

  class ARRAYCORE_EXPORT FKSteering
  {
  public:
    FKSteering();
    ~FKSteering();

    void setArray(const ArraySelection * array) {_array=array;}
    double dataSizeMb() const;
  protected:
    void resize(int n);

    const ArraySelection * _array;

    friend class FKPower;
    // One component
    ComplexMatrix _e;
    ComplexMatrix _eh;
    /*ComplexMatrix _ehrx, _ehry,
                  _ehrxrx, _ehryry, _ehrxry,
                  _rxe, _rye;*/
    // Three component
    double _ell2;
    /*double _ell, _2ell, _ell2, _invk, _2inve, _4inv3e, _8inv3e, _2inv3e2;
    double _ellFactor, _ellFactor2;*/
    Angle _theta;
    /*double _sink, _cosk, _esink, _ecosk, _ecos2k2, _esin2k2, _ecossink2, _e2cossink2, _e2sin2k2, _e2cos2k2;
    ComplexMatrix _t, _th, _u, _uh, _thrx, _thry, _uhrx, _uhry;*/
  };

} // namespace ArrayCore

#endif // FKSTEERING_H

