/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-08-29
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ACTIVEFKTOOL_H
#define ACTIVEFKTOOL_H

#include "FKTool.h"
#include "ActiveFKTaskManager.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT ActiveFKTool : public FKTool
  {
  public:
    ActiveFKTool();
    ~ActiveFKTool();

    bool setParameters(const AbstractParameters &param);

    void setSource(const SeismicEvent * e);
    const SeismicEvent * source() const {return _source;}

    virtual bool setWaveNumberGrid();

    const IrregularGrid2D& grid() const {return *_grid;}
  protected:
    virtual QString toolName() {return tr("Active FK Array analysis");}
    virtual TaskManager * createLoop() {return new ActiveFKTaskManager(array(), _source, _grid);}
  private:
    void setGrid(const ActiveFKParameters& param);

    const SeismicEvent * _source;
    IrregularGrid2D * _grid;
  };

} // namespace ArrayCore

#endif // ACTIVEFKTOOL_H

