/***************************************************************************
**
**  This file is part of waran.
**
**  waran is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  waran is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-07-14
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef REALTIMEHISTOGRAM_H
#define REALTIMEHISTOGRAM_H

#include <QGpCoreMath.h>

class RealTimeHistogram : public IrregularGrid2D
{
public:
  RealTimeHistogram();

  void init(const SamplingParameters& xSampling, int yCount, double yMin, double yMax, SamplingOption ySampling);
  void clear() {IrregularGrid2D::init(0.0);}
  void add(const Point2D& p);
private:
  double _currentX;
  double * _currentCell;
};

#endif // REALTIMEHISTOGRAM_H
