/***************************************************************************
**
**  This file is part of max2curve.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-06-01
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QTextStream>

#include <QGpCoreTools.h>
#include "TFAMaxEntry.h"

/*!
  \class TFAMaxEntry TFAMaxEntry.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

bool TFAMaxEntry::operator<(const MaxEntry& o) const
{
  TRACE;
  if(x()<o.x()) return true;
  else if(x()>o.x()) return false;
  const TFAMaxEntry& m=static_cast<const TFAMaxEntry&>(*this);
  const TFAMaxEntry& mo=static_cast<const TFAMaxEntry&>(o);
  if(m._vAmplitude>mo._vAmplitude) return true;
  else if(m._vAmplitude<mo._vAmplitude) return false;
  if(value()<o.value()) return true;
  else return false;
}

bool TFAMaxEntry::readLine(QTextStream& s)
{
  TRACE;
  QString line;
  do {
    line=s.readLine();
  } while(!line.isEmpty() && line[0]=='#');
  if(!line.isEmpty()) {
    const QChar * ptr=0;
    StringSection field,fields(line);
    field=fields.nextField(ptr);
    _time=field.toDouble();
    field=fields.nextField(ptr);
    _x=field.toDouble();
    field=fields.nextField(ptr);
    _hv=field.toDouble();
    field=fields.nextField(ptr);
    _vAmplitude=field.toDouble();
    field=fields.nextField(ptr);
    _hAmplitude=field.toDouble();
    field=fields.nextField(ptr);
    _delay=field.toDouble();
    field=fields.nextField(ptr);
    if(field.isValid())
      _selected=field.toInt()>0 ? true : false;
    else
      _selected=true; // compatibility with format out of Geopsy and Cap
    return true;
  } else {
    return false;
  }
}

void TFAMaxEntry::writeLine(QTextStream& s) const
{
  TRACE;
  static const QString fmt("%1 %2 %3 %4 %5 %6 %7");
  s << fmt.arg(_time).arg(_x).arg(_hv).arg(_vAmplitude).arg(_hAmplitude).arg(_delay).arg(_selected) << endl;
}

bool TFAMaxEntry::isHeaderLine(QString f)
{
  TRACE;
  return f.contains("secondsfromstart|cfreq|h/v|ampz|amph|delay");
}

QByteArray TFAMaxEntry::fields()
{
  TRACE;
  return "seconds from start | cfreq | H/V | AmpZ | AmpH | Delay";
}

void TFAMaxEntry::writeHeader(QTextStream& s) const
{
  TRACE;
  s << "# File generated by max2curve, TFA post-processing\n";
  s << QString( "# %1 | selected").arg(fields().data()) << endl;
}

void TFAMaxEntry::includeAmplitude(double& minVAmplitude, double& maxVAmplitude)
{
  TRACE;
  if(_vAmplitude < minVAmplitude) minVAmplitude=_vAmplitude;
  if(_vAmplitude > maxVAmplitude) maxVAmplitude=_vAmplitude;
}
